/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.lib.uihandler.Decorable;
import org.netbeans.lib.uihandler.Decorations;
import org.netbeans.lib.uihandler.LogFormatter;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class LogRecords {
    private static final Logger LOG = Logger.getLogger(LogRecords.class.getName());
    private static final Formatter FORMATTER = new LogFormatter();
    private static final String RECORD_ELM_START = "<record>";
    private static final String RECORD_ELM_END = "</record>";

    private LogRecords() {
    }

    public static void decorate(LogRecord logRecord, Decorable decorable) {
        Decorations.decorate(logRecord, decorable);
    }

    public static void write(OutputStream outputStream, LogRecord logRecord) throws IOException {
        String string = FORMATTER.format(logRecord);
        byte[] byArray = string.getBytes("utf-8");
        outputStream.write(byArray);
        outputStream.flush();
    }

    public static void scan(File file, Handler handler) throws IOException {
        HandlerDelegate handlerDelegate = new HandlerDelegate(handler);
        FileInputStream fileInputStream = null;
        ArrayList<LogRecord> arrayList = new ArrayList<LogRecord>();
        try {
            fileInputStream = new FileInputStream(file);
            LogRecords.scan(fileInputStream, handlerDelegate, arrayList);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "LogRecords scan threw {0}", iOException.toString());
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            fileInputStream = null;
            if (LogRecords.repairFile(file)) {
                arrayList.clear();
                LOG.info("LogRecords File repaired. :-)");
                handlerDelegate.setContinueAfterLast();
                fileInputStream = new FileInputStream(file);
                LogRecords.scan(fileInputStream, (Handler)handlerDelegate);
                return;
            }
            LOG.info("LogRecords File NOT repaired. :-(");
            LOG.severe("Throwing the original exception... :-(");
            throw iOException;
        }
        finally {
            for (LogRecord logRecord : arrayList) {
                LOG.log(logRecord);
            }
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scan(InputStream inputStream, Handler handler) throws IOException {
        ArrayList<LogRecord> arrayList = new ArrayList<LogRecord>();
        try {
            LogRecords.scan(inputStream, handler, arrayList);
        }
        finally {
            for (LogRecord logRecord : arrayList) {
                LOG.log(logRecord);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void scan(InputStream inputStream, Handler handler, List<LogRecord> list) throws IOException {
        Object object;
        Object object2;
        Object object3;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 32);
        byte[] byArray = new byte[5];
        int n = pushbackInputStream.read(byArray);
        if (n == -1) {
            return;
        }
        pushbackInputStream.unread(byArray, 0, n);
        if (byArray[0] == 31 && byArray[1] == -117) {
            n = (pushbackInputStream = new PushbackInputStream(new GZIPInputStream(pushbackInputStream), 32)).read(byArray);
            if (n == -1) {
                return;
            }
            pushbackInputStream.unread(byArray, 0, n);
        }
        if (byArray[0] == 60 && byArray[1] == 63 && byArray[2] == 120 && byArray[3] == 109 && byArray[4] == 108) {
            inputStream = pushbackInputStream;
        } else {
            object3 = new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><uigestures version='1.0'>".getBytes());
            object2 = new ByteArrayInputStream("</uigestures>".getBytes());
            inputStream = new SequenceInputStream(new SequenceInputStream((InputStream)object3, pushbackInputStream), (InputStream)object2);
        }
        object3 = SAXParserFactory.newInstance();
        ((SAXParserFactory)object3).setValidating(false);
        try {
            try {
                ((SAXParserFactory)object3).setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                object = new LogRecord(Level.INFO, null);
                ((LogRecord)object).setThrown(sAXNotRecognizedException);
                list.add((LogRecord)object);
            }
            object2 = ((SAXParserFactory)object3).newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, null);
            logRecord.setThrown(parserConfigurationException);
            list.add(logRecord);
            throw new IOException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, null);
            logRecord.setThrown(sAXException);
            list.add(logRecord);
            throw new IOException(sAXException);
        }
        Parser parser = new Parser(handler);
        try {
            ((SAXParser)object2).parse(inputStream, (DefaultHandler)parser);
        }
        catch (SAXParseException sAXParseException) {
            try {
                LogRecord logRecord = new LogRecord(Level.WARNING, "Line = " + sAXParseException.getLineNumber() + ", column = " + sAXParseException.getColumnNumber());
                logRecord.setThrown(sAXParseException);
                list.add(logRecord);
                throw new IOException(sAXParseException);
                catch (SAXException sAXException) {
                    LogRecord logRecord2 = new LogRecord(Level.WARNING, null);
                    logRecord2.setThrown(sAXException);
                    list.add(logRecord2);
                    throw new IOException(sAXException);
                }
                catch (InternalError internalError) {
                    LogRecord logRecord3 = new LogRecord(Level.WARNING, "Input file corruption");
                    logRecord3.setThrown(internalError);
                    list.add(logRecord3);
                    throw new IOException(internalError);
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (RuntimeException runtimeException) {
                    LogRecord logRecord4 = new LogRecord(Level.WARNING, "Input file corruption");
                    logRecord4.setThrown(runtimeException);
                    list.add(logRecord4);
                    throw new IOException(runtimeException);
                }
            }
            catch (Throwable throwable) {
                List<SAXParseException> list2 = parser.getFatalErrors();
                if (list2 != null) {
                    for (SAXParseException sAXParseException2 : list2) {
                        LogRecord logRecord = new LogRecord(Level.WARNING, "Fatal SAX Parse Exception: Line = " + sAXParseException2.getLineNumber() + ", column = " + sAXParseException2.getColumnNumber());
                        logRecord.setThrown(sAXParseException2);
                        list.add(logRecord);
                    }
                }
                throw throwable;
            }
        }
        object = parser.getFatalErrors();
        if (object != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SAXParseException sAXParseException = (SAXParseException)iterator.next();
                LogRecord logRecord = new LogRecord(Level.WARNING, "Fatal SAX Parse Exception: Line = " + sAXParseException.getLineNumber() + ", column = " + sAXParseException.getColumnNumber());
                logRecord.setThrown(sAXParseException);
                list.add(logRecord);
            }
        }
    }

    static Level parseLevel(String string) {
        return "USER".equals(string) ? Level.SEVERE : Level.parse(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean repairFile(File file) {
        boolean bl = false;
        RandomAccessFile randomAccessFile = null;
        try {
            String string;
            randomAccessFile = new RandomAccessFile(file, "rw");
            String string2 = null;
            long l = -1L;
            long l2 = -1L;
            while ((string = randomAccessFile.readLine()) != null) {
                if (string.equals(RECORD_ELM_END)) {
                    l = randomAccessFile.getFilePointer();
                }
                if (string.endsWith(RECORD_ELM_START)) {
                    long l3 = randomAccessFile.getFilePointer();
                    long l4 = l3 - (long)RECORD_ELM_START.length() - 1L;
                    if (0L < l && l < l4) {
                        LogRecords.deletePart(randomAccessFile, l, l4);
                        long l5 = l4 - l;
                        randomAccessFile.seek(l3 - l5);
                        l -= l5;
                        l4 -= l5;
                        bl = true;
                    } else if (l2 < 0L && (l < 0L || l == l4)) {
                        LogRecords.deletePart(randomAccessFile, 0L, l4);
                        randomAccessFile.seek(0L);
                        l = 0L;
                        l4 = 0L;
                        bl = true;
                    }
                    l2 = l4;
                }
                if (string.trim().isEmpty()) continue;
                string2 = string;
            }
            if (string2 != null && !RECORD_ELM_END.equals(string2) && l > 0L) {
                LogRecords.deletePart(randomAccessFile, l, randomAccessFile.length());
                bl = true;
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (IOException iOException) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void deletePart(RandomAccessFile randomAccessFile, long l, long l2) throws IOException {
        if (l == l2) {
            return;
        }
        assert (l < l2) : "The first position is higher: " + l + ", " + l2 + ".";
        int n = 3;
        byte[] byArray = new byte[n];
        long l3 = randomAccessFile.length();
        while (l2 + (long)n <= l3) {
            randomAccessFile.seek(l2);
            randomAccessFile.readFully(byArray);
            randomAccessFile.seek(l);
            randomAccessFile.write(byArray);
            l += (long)n;
            l2 += (long)n;
        }
        if (l2 < l3) {
            int n2 = (int)(l3 - l2);
            randomAccessFile.seek(l2);
            randomAccessFile.readFully(byArray, 0, n2);
            randomAccessFile.seek(l);
            randomAccessFile.write(byArray, 0, n2);
        }
        randomAccessFile.setLength(l3 - (l2 - l));
    }

    private static final class FakeException
    extends Exception {
        final List<StackTraceElement> trace = new ArrayList<StackTraceElement>();
        Map<Parser.Elem, String> values;
        String message;
        int more;

        public FakeException(Map<Parser.Elem, String> map) {
            this.values = map;
            this.more = 0;
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.trace.toArray(new StackTraceElement[0]);
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public int getMore() {
            return this.more;
        }

        @Override
        public String toString() {
            return this.message;
        }
    }

    private static final class FakeBundle
    extends ResourceBundle {
        private String key;
        private String value;

        public FakeBundle(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        @Override
        protected Object handleGetObject(String string) {
            if (this.key.equals(string)) {
                return this.value;
            }
            return null;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(Collections.singleton(this.key));
        }
    }

    private static final class Parser
    extends DefaultHandler {
        private Handler callback;
        private Map<Elem, String> values = new EnumMap<Elem, String>(Elem.class);
        private Elem current;
        private FakeException currentEx;
        private Queue<FakeException> exceptions;
        private List<String> params;
        private StringBuilder chars = new StringBuilder();
        private List<SAXParseException> fatalErrors;

        public Parser(Handler handler) {
            this.callback = handler;
        }

        public List<SAXParseException> getFatalErrors() {
            return this.fatalErrors;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
            this.callback.flush();
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "uri: {0} localName: {1} qName: {2} atts: {3}", new Object[]{string, string2, string3, attributes});
            }
            try {
                this.current = Elem.valueOf(string3.toUpperCase());
                if (this.current == Elem.EXCEPTION) {
                    this.currentEx = new FakeException(new EnumMap<Elem, String>(this.values));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.log(Level.FINE, "Uknown tag " + string3, illegalArgumentException);
                this.current = null;
            }
            this.chars = new StringBuilder();
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            Object object;
            String string4;
            if (this.current != null) {
                string4 = this.chars.toString();
                this.values.put(this.current, string4);
                if (this.current == Elem.PARAM) {
                    if (this.params == null) {
                        this.params = new ArrayList<String>();
                    }
                    this.params.add(string4);
                    if (this.params.size() > 1500) {
                        LOG.log(Level.SEVERE, "Too long params when reading a record. Deleting few. Msg: {0}", Elem.MESSAGE.parse(this.values));
                        for (String string5 : this.params) {
                            LOG.fine(string5);
                        }
                        this.params.clear();
                    }
                }
            }
            this.current = null;
            this.chars = new StringBuilder();
            if (this.currentEx != null && this.currentEx.values != null) {
                if ("frame".equals(string3)) {
                    string4 = Elem.LINE.parse(this.values);
                    object = new StackTraceElement(Elem.CLASS.parse(this.values), Elem.METHOD.parse(this.values), Elem.FILE.parse(this.values), string4 == null ? -1 : Integer.parseInt(string4));
                    this.currentEx.trace.add((StackTraceElement)object);
                    this.values.remove((Object)Elem.CLASS);
                    this.values.remove((Object)Elem.METHOD);
                    this.values.remove((Object)Elem.LINE);
                }
                if ("exception".equals(string3)) {
                    this.currentEx.message = this.values.get((Object)Elem.MESSAGE);
                    string4 = this.values.get((Object)Elem.MORE);
                    if (string4 != null) {
                        this.currentEx.more = Integer.parseInt(string4);
                    }
                    if (this.exceptions == null) {
                        this.exceptions = new LinkedList<FakeException>();
                    }
                    this.exceptions.add(this.currentEx);
                    this.values = this.currentEx.values;
                    this.currentEx = null;
                }
                return;
            }
            if ("record".equals(string3)) {
                String string5;
                string4 = Elem.MILLIS.parse(this.values);
                object = Elem.SEQUENCE.parse(this.values);
                string5 = Elem.LEVEL.parse(this.values);
                String string6 = Elem.THREAD.parse(this.values);
                String string7 = Elem.MESSAGE.parse(this.values);
                String string8 = Elem.KEY.parse(this.values);
                String string9 = Elem.CATALOG.parse(this.values);
                if (string5 != null) {
                    LogRecord logRecord = new LogRecord(LogRecords.parseLevel(string5), string8 != null && string9 != null ? string8 : string7);
                    try {
                        logRecord.setThreadID(this.parseInt(string6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOG.log(Level.WARNING, numberFormatException.getMessage(), numberFormatException);
                    }
                    logRecord.setSequenceNumber(this.parseLong((String)object));
                    logRecord.setMillis(this.parseLong(string4));
                    logRecord.setResourceBundleName(string8);
                    if (string9 != null && string8 != null) {
                        logRecord.setResourceBundleName(string9);
                        if (!"<null>".equals(string9)) {
                            try {
                                ResourceBundle resourceBundle = NbBundle.getBundle((String)string9);
                                resourceBundle.getObject(string8);
                                logRecord.setResourceBundle(resourceBundle);
                            }
                            catch (MissingResourceException missingResourceException) {
                                LOG.log(Level.CONFIG, "Cannot find resource bundle {0} for key {1}", new Object[]{string9, string8});
                                logRecord.setResourceBundle(new FakeBundle(string8, string7));
                            }
                        } else {
                            LOG.log(Level.CONFIG, "Cannot find resource bundle <null> for key {1}", string8);
                        }
                    }
                    if (this.params != null) {
                        logRecord.setParameters(this.params.toArray());
                    }
                    if (this.exceptions != null) {
                        logRecord.setThrown(this.createThrown(null));
                    }
                    this.callback.publish(logRecord);
                }
                this.currentEx = null;
                this.params = null;
                this.values.clear();
            }
        }

        private long parseLong(String string) {
            if (string == null) {
                return 0L;
            }
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
                return 0L;
            }
        }

        private int parseInt(String string) {
            if (string == null) {
                return 0;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
                return 0;
            }
        }

        private FakeException createThrown(FakeException fakeException) {
            StackTraceElement[] stackTraceElementArray;
            if (this.exceptions.size() == 0) {
                return null;
            }
            FakeException fakeException2 = this.exceptions.poll();
            if (fakeException2.getMore() != 0) {
                assert (fakeException != null) : "IF MORE IS NOT 0, LAST MUST BE SET NOT NULL";
                stackTraceElementArray = fakeException.getStackTrace();
                for (int i = stackTraceElementArray.length - fakeException2.getMore(); i < stackTraceElementArray.length; ++i) {
                    fakeException2.trace.add(stackTraceElementArray[i]);
                }
            }
            stackTraceElementArray = this.createThrown(fakeException2);
            fakeException2.initCause((Throwable)stackTraceElementArray);
            return fakeException2;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.chars.append(cArray, n, n2);
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            if (this.fatalErrors == null) {
                this.fatalErrors = new LinkedList<SAXParseException>();
            }
            this.fatalErrors.add(sAXParseException);
            if (this.fatalErrors.size() > 100) {
                throw sAXParseException;
            }
        }

        private static enum Elem {
            UIGESTURES,
            RECORD,
            DATE,
            MILLIS,
            SEQUENCE,
            LEVEL,
            THREAD,
            MESSAGE,
            KEY,
            PARAM,
            FRAME,
            CLASS,
            METHOD,
            LOGGER,
            EXCEPTION,
            LINE,
            CATALOG,
            MORE,
            FILE;


            public String parse(Map<Elem, String> map) {
                String string = map.get((Object)this);
                return string;
            }
        }
    }

    private static class HandlerDelegate
    extends Handler {
        private Handler hd;
        private boolean afterLast;
        private long lastNumber;

        HandlerDelegate(Handler handler) {
            this.hd = handler;
        }

        @Override
        public void publish(LogRecord logRecord) {
            long l = logRecord.getSequenceNumber();
            if (this.afterLast) {
                if (l <= this.lastNumber) {
                    return;
                }
                this.afterLast = false;
            }
            this.lastNumber = l;
            this.hd.publish(logRecord);
        }

        @Override
        public void flush() {
            this.hd.flush();
        }

        @Override
        public void close() throws SecurityException {
            this.hd.close();
        }

        public String toString() {
            return this.hd.toString();
        }

        void setContinueAfterLast() {
            this.afterLast = true;
        }
    }
}

