/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.InstanceConstructor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.GenericGrowableArray;

public class GrowableArray<T>
extends GenericGrowableArray {
    private static AddressField dataField;
    private InstanceConstructor<T> virtualConstructor;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("GrowableArray<int>");
        dataField = type.getAddressField("_data");
    }

    public static <S> GrowableArray<S> create(Address addr, InstanceConstructor<S> v) {
        if (addr == null) {
            return null;
        }
        return new GrowableArray<S>(addr, v);
    }

    public T at(int i) {
        if (i < 0 || i >= this.length()) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        Address data = dataField.getValue(this.getAddress());
        Address addr = data.getAddressAt((long)i * VM.getVM().getAddressSize());
        if (addr == null) {
            return null;
        }
        return this.virtualConstructor.instantiateWrapperFor(addr);
    }

    private GrowableArray(Address addr, InstanceConstructor<T> v) {
        super(addr);
        this.virtualConstructor = v;
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                GrowableArray.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

