/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui;

import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.ui.images.internal.ImageConstants;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.preferences.PreferenceKeys;
import com.jrockit.mc.ui.MCAbstractUIPlugin;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public final class FlightRecorderUI
extends MCAbstractUIPlugin {
    public static final String TEMP_RECORDINGS_FOLDER = "tempRecordings";
    public static final String PLUGIN_ID = "com.jrockit.mc.flightrecorder.ui";
    private static FlightRecorderUI plugin;

    public FlightRecorderUI() {
        super(PLUGIN_ID);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerFromImageConstantClass(registry, ImageConstants.class);
    }

    public boolean removeFinishedRecordings() {
        return this.getPreferenceStore().getBoolean("flightRecorder.removeFinishedRecording");
    }

    public boolean getConfirmRemoveTemplate() {
        return this.getPreferenceStore().getBoolean("flightRecorder.confirmRemoveTemplate");
    }

    public void setConfirmRemoveTemplate(boolean value) {
        this.getPreferenceStore().setValue("flightRecorder.confirmRemoveTemplate", value);
    }

    public IQuantity getLastPartToDumpTimespan() {
        return FlightRecorderUI.parseDumpTimespan(this.getPreferenceStore().getString("flightrecorder.controlpanel.default.dump.timespan"));
    }

    public static IQuantity parseDumpTimespan(String timespan) {
        try {
            return UnitLookup.TIMESPAN.parsePersisted(timespan);
        }
        catch (QuantityConversionException e) {
            return PreferenceKeys.DUMP_TIMESPAN_DEFAULT;
        }
    }

    public static String validateDumpTimespan(String text) {
        try {
            LinearQuantity timespan = UnitLookup.TIMESPAN.parseInteractive(text);
            if (timespan.doubleValue() <= 0.0) {
                return Messages.DUMP_RECORDING_TIMESPAN_LESS_THAN_ZERO;
            }
        }
        catch (QuantityConversionException qce) {
            return NLS.bind((String)Messages.DUMP_RECORDING_TIMESPAN_UNPARSABLE, (Object)qce.getLocalizedMessage());
        }
        return null;
    }

    public boolean isSetLastPartToDump() {
        return this.getPreferenceStore().getInt("flightrecorder.controlpanel.default.dump.type") == 1;
    }

    public boolean isSetDumpWhole() {
        return this.getPreferenceStore().getInt("flightrecorder.controlpanel.default.dump.type") == 2;
    }

    public boolean getShowMonitoringWarning() {
        return this.getPreferenceStore().getBoolean("flightrecorder.controlpanel.show.monitoring.warning");
    }

    public void setShowMonitoringWarning(boolean showWarning) {
        this.getPreferenceStore().setValue("flightrecorder.controlpanel.show.monitoring.warning", showWarning);
    }

    public boolean getShowHiddenMethods() {
        return this.getPreferenceStore().getBoolean("flightRecorder.showHiddenMethods");
    }

    public File getTempRecordingsDir() throws IOException {
        File dir = this.getStateLocation().append(TEMP_RECORDINGS_FOLDER).toFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException(NLS.bind((String)Messages.FOLDER_COULD_NOT_BE_CREATED, (Object)dir.getAbsolutePath()));
        }
        return dir;
    }

    public static FlightRecorderUI getDefault() {
        return plugin;
    }
}

