/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import java.util.Observable;

public class LayoutData
extends Observable {
    private static final String WEIGHT = "weight";
    private static final String MINIMUM_SIZE = "minimumSize";
    private static final String MAXIMUM_SIZE = "maximumSize";
    private static final int DEFAULT_MAX_WIDTH = Integer.MAX_VALUE;
    private final Setting m_setting = new Setting("layoutData");

    static {
        PersistenceToolkit.registerFetcher(LayoutData.class, (ISettingFetcher)new ISettingFetcher<LayoutData>(){

            public Setting getSetting(LayoutData layoutData) {
                return layoutData.m_setting;
            }
        });
    }

    public LayoutData() {
        this.setWeight(1.0f);
        this.setMinimumSize(0);
        this.setMaximumSize(Integer.MAX_VALUE);
    }

    public int getMaximumSize() {
        return (Integer)this.m_setting.getChildObject(MAXIMUM_SIZE, Integer.class);
    }

    public int getMinimumSize() {
        return (Integer)this.m_setting.getChildObject(MINIMUM_SIZE, Integer.class);
    }

    public float getWeight() {
        return ((Float)this.m_setting.getChildObject(WEIGHT, Float.class)).floatValue();
    }

    public void setMinimumSize(int value) {
        this.m_setting.setChildObject(MINIMUM_SIZE, (Object)value);
        this.setChanged();
    }

    public void setMaximumSize(int size) {
        this.m_setting.setChildObject(MAXIMUM_SIZE, (Object)size);
        this.setChanged();
    }

    public void setWeight(float weight) {
        this.m_setting.setChildObject(WEIGHT, (Object)Float.valueOf(weight));
        this.setChanged();
    }
}

