/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.CompositeInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.InputPanel;
import com.jrockit.mc.components.ui.util.StatusProvider;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class ListInput<T>
extends CompositeInput {
    private final StatusProvider m_statusProvider = new StatusProvider();
    private List<T> m_detailList;
    private InputPanel m_detailPanel;
    private StructuredViewer m_tableViewer;
    private Button m_addButton;
    private Button m_removeButton;
    private Button m_upButton;
    private Button m_downButton;
    private IInput m_panel;

    protected abstract List<T> createDetailList();

    protected abstract List<T> createNew(Shell var1);

    protected abstract StructuredViewer createTableViewer(Composite var1);

    protected abstract IInput createTopInput();

    public ListInput(String name, String key) {
        super(name, key);
    }

    public ListInput(String name) {
        super(name, null);
    }

    private List<T> getDetailList() {
        return this.m_detailList;
    }

    @Override
    public void create(Composite parent, int horizontalSpan) {
        this.m_panel = this.createTopInput();
        if (this.m_panel != null) {
            this.m_panel.create(parent, horizontalSpan);
        }
        GridData gd = new GridData(4, 4, true, true);
        Composite detailComposite = this.createDetails(parent);
        gd.horizontalSpan = horizontalSpan;
        detailComposite.setLayoutData((Object)gd);
    }

    @Override
    public void setSetting(Setting setting) {
        if (this.m_panel != null) {
            this.m_panel.setSetting(setting);
        }
        this.refresh();
    }

    private Composite createDetails(Composite parent) {
        Composite detailComposite = new Composite(parent, 0);
        detailComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        GridData gd1 = new GridData(4, 4, true, false);
        gd1.heightHint = 70;
        Control viewerControl = this.createViewer(detailComposite);
        viewerControl.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, false);
        Composite buttonPanel = this.createButtonPanel(detailComposite);
        buttonPanel.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = 2;
        this.m_detailList = this.createDetailList();
        this.m_detailPanel = new InputPanel(detailComposite, null, this.getInputs());
        this.m_detailPanel.addStatusListener(new IStatusListener(){

            @Override
            public void onChange(IStatus status) {
                if (status.getSeverity() == 1) {
                    ListInput.this.m_tableViewer.refresh();
                }
                ListInput.this.m_statusProvider.fireChange(status);
            }
        });
        this.m_detailPanel.getControl().setLayoutData((Object)gd3);
        this.m_tableViewer.setInput(this.getDetailList());
        this.updateButtons();
        return detailComposite;
    }

    private Composite createButtonPanel(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridData gd1 = new GridData(4, 4, false, false);
        this.m_addButton = this.createAddButton(container);
        this.m_addButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, false);
        this.m_removeButton = this.createRemoveButton(container);
        this.m_removeButton.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, false);
        this.m_upButton = this.createMoveButton(container, Messages.MASTER_DETAIL_INPUT_MOVE_UP_BUTTON_TEXT, -1);
        this.m_upButton.setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, false, false);
        this.m_downButton = this.createMoveButton(container, Messages.MASTER_DETAIL_INPUT_MOVE_DOWN_BUTTON_TEXT, 1);
        this.m_downButton.setLayoutData((Object)gd4);
        return container;
    }

    private Button createMoveButton(Composite parent, String text, final int delta) {
        Button button = new Button(parent, 0);
        button.setText(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = ListInput.this.getDetailList().indexOf(ListInput.this.getSelected());
                Collections.swap(ListInput.this.getDetailList(), index, index + delta);
                ListInput.this.m_tableViewer.refresh();
                ListInput.this.updateButtons();
            }
        });
        return button;
    }

    private void updateButtons() {
        int selectedIndex = this.getSelectedIndex();
        this.updateUpButton(selectedIndex);
        this.updateDownButton(selectedIndex);
        this.updateRemoveButton(selectedIndex);
    }

    private int getSelectedIndex() {
        Object selected = this.getSelected();
        if (selected != null) {
            return this.getDetailList().indexOf(selected);
        }
        return -1;
    }

    private void updateRemoveButton(int index) {
        this.m_removeButton.setEnabled(index != -1);
    }

    private void updateDownButton(int index) {
        this.m_downButton.setEnabled(index != -1 && index < this.getDetailList().size() - 1);
    }

    private void updateUpButton(int index) {
        this.m_upButton.setEnabled(index > 0);
    }

    private Button createRemoveButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.MASTER_DETAIL_INPUT_REMOVE_BUTTON_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListInput.this.removeSelected();
            }
        });
        return button;
    }

    private Button createAddButton(final Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.MASTER_DETAIL_INPUT_ADD_BUTTON_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListInput.this.add(parent.getShell());
            }
        });
        return button;
    }

    private void add(Shell shell) {
        final List<T> list = this.createNew(shell);
        if (list != null && !list.isEmpty()) {
            this.getDetailList().addAll(list);
            this.m_tableViewer.setInput(this.getDetailList());
            this.m_detailPanel.setSetting(PersistenceToolkit.getSetting(list.get(0)));
            this.updateButtons();
            DisplayToolkit.safeAsyncExec((Widget)shell, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ListInput.this.m_tableViewer.setSelection((ISelection)new StructuredSelection(list.get(0)));
                }
            });
        }
    }

    private Object getSelected() {
        IStructuredSelection ss = (IStructuredSelection)this.m_tableViewer.getSelection();
        if (!ss.isEmpty()) {
            return ss.getFirstElement();
        }
        return null;
    }

    private Control createViewer(Composite parent) {
        this.m_tableViewer = this.createTableViewer(parent);
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = ListInput.this.getSelected();
                if (object != null) {
                    Setting setting = PersistenceToolkit.getSetting((Object)object);
                    ListInput.this.m_detailPanel.setSetting(setting);
                } else {
                    ListInput.this.m_detailPanel.setSetting(null);
                }
                ListInput.this.updateButtons();
            }
        });
        return this.m_tableViewer.getControl();
    }

    @Override
    public IStatus getStatus() {
        return this.m_statusProvider.getStatus();
    }

    private void removeSelected() {
        Object selected = this.getSelected();
        if (selected != null) {
            this.getDetailList().remove(selected);
            this.m_tableViewer.setInput(this.getDetailList());
        } else {
            this.m_detailPanel.setSetting(null);
        }
    }
}

