/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ScrollAction
extends AbstractAction
implements ChangeListener,
MouseWheelListener {
    private final JScrollPane scrollPane;
    private final boolean isHorizontal;
    private final boolean isScrollLeft;

    public ScrollAction(JScrollPane jScrollPane, int n, boolean bl) {
        this.isScrollLeft = bl;
        this.scrollPane = jScrollPane;
        this.isHorizontal = n == 1 || n == 3;
        jScrollPane.getViewport().addChangeListener(this);
        jScrollPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ScrollAction.this.updateEnabled();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.updateEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.getDefaultIncrement();
        this.scroll(n);
    }

    private void updateEnabled() {
        boolean bl = true;
        Component component = this.scrollPane.getViewport().getView();
        if (null != component) {
            Dimension dimension = component.getSize();
            Dimension dimension2 = this.scrollPane.getViewport().getExtentSize();
            Point point = this.scrollPane.getViewport().getViewPosition();
            bl = this.isHorizontal ? (this.isScrollLeft ? point.x > 0 : point.x + dimension2.width < dimension.width) : (this.isScrollLeft ? point.y > 0 : point.y + dimension2.height < dimension.height);
        }
        this.setEnabled(bl);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateEnabled();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0 && this.isScrollLeft || n > 0 && !this.isScrollLeft) {
            int n2 = this.getDefaultIncrement();
            this.scroll(n2 *= Math.abs(n));
            mouseWheelEvent.consume();
        }
    }

    private int getDefaultIncrement() {
        Component component = this.scrollPane.getViewport().getView();
        Point point = this.scrollPane.getViewport().getViewPosition();
        int n = this.isHorizontal ? 30 : 8;
        Dimension dimension = this.scrollPane.getViewport().getExtentSize();
        if (component instanceof Scrollable) {
            n = ((Scrollable)((Object)component)).getScrollableUnitIncrement(new Rectangle(point, dimension), this.isHorizontal ? 0 : 1, this.isScrollLeft ? -1 : 1);
        }
        return n;
    }

    private void scroll(int n) {
        Component component = this.scrollPane.getViewport().getView();
        Dimension dimension = component.getSize();
        Dimension dimension2 = this.scrollPane.getViewport().getExtentSize();
        Point point = this.scrollPane.getViewport().getViewPosition();
        if (this.isHorizontal) {
            point.x += n;
            point.x = Math.max(point.x, 0);
            point.x = Math.min(point.x, dimension.width - dimension2.width);
        } else {
            point.y += n;
            point.y = Math.max(point.y, 0);
            point.y = Math.min(point.y, dimension.height - dimension2.height);
        }
        this.scrollPane.getViewport().setViewPosition(point);
    }
}

